<?php
/*--------------------------------------------------------------
   Serial.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

use Gambio\Admin\Modules\Statistics\Model\Collections\SerialCategories;
use Gambio\Admin\Modules\Statistics\Model\Collections\SerialItems;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

class Serial implements Data
{
    /**
     * @var SerialCategories
     */
    private $categories;
    
    /**
     * @var SerialItems
     */
    private $series;
    
    /**
     * @var string
     */
    private $type;
    
    
    /**
     * Constructor.
     */
    private function __construct(SerialCategories $categories, SerialItems $series)
    {
        $this->categories = $categories;
        $this->series     = $series;
        $this->type       = 'serial';
    }
    
    
    /**
     * Create instance.
     */
    public static function create(SerialCategories $categories, SerialItems $series): self
    {
        return new self($categories, $series);
    }
    
    
    /**
     * Return categories.
     */
    public function categories(): SerialCategories
    {
        return $this->categories;
    }
    
    
    /**
     * Return series.
     */
    public function series(): SerialItems
    {
        return $this->series;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->type;
    }
}